package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aPlantillasXSLT;

/**
 * Ab18a05s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aPlantillasXSLTDaoImpl implements Ab18aPlantillasXSLTDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aPlantillasXSLT> rwMap = new RowMapper<Ab18aPlantillasXSLT>() {
		public Ab18aPlantillasXSLT mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aPlantillasXSLT(
					resultSet.getLong("T05IDPLANTILLAVALID"),
					resultSet.getDate("T05FECHABAJA"),
					resultSet.getClob("T05PLANTILLAVALID"),
					resultSet.getLong("T06IDBOLETIN"));
		}
	};

	private RowMapper<Ab18aPlantillasXSLT> rwMapPK = new RowMapper<Ab18aPlantillasXSLT>() {
		public Ab18aPlantillasXSLT mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aPlantillasXSLT(
					resultSet.getLong("T05IDPLANTILLAVALID"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aPlantillasXSLT>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aPlantillasXSLT>>() {
		public JerarquiaDto<Ab18aPlantillasXSLT> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			Ab18aPlantillasXSLT ab18a05s00 = new Ab18aPlantillasXSLT(
					resultSet.getLong("T05IDPLANTILLAVALID"),
					resultSet.getDate("T05FECHABAJA"),
					resultSet.getClob("T05PLANTILLAVALID"),
					resultSet.getLong("T06IDBOLETIN"));

			JerarquiaDto<Ab18aPlantillasXSLT> jerarquia = new JerarquiaDto<Ab18aPlantillasXSLT>();
			jerarquia.setModel(ab18a05s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a05s00 table.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @return Ab18a05s00
	 */
	public Ab18aPlantillasXSLT add(Ab18aPlantillasXSLT ab18a05s00) {
		String query = "INSERT INTO AB18A05S00 (T05_ID_PLANTILLA_VALID, T06_ID_BOLETIN, T05_FECHA_BAJA, T05_PLANTILLA_VALID) VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, ab18a05s00.getT05IdPlantillaValid(),
				ab18a05s00.getT06IdBoletin(), ab18a05s00.getT05FechaBaja(),
				ab18a05s00.getT05PlantillaValid());
		return ab18a05s00;
	}

	/**
	 * Updates a single row in the Ab18a05s00 table.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @return Ab18a05s00
	 */
	public Ab18aPlantillasXSLT update(Ab18aPlantillasXSLT ab18a05s00) {
		String query = "UPDATE AB18A05S00 SET T06_ID_BOLETIN=?, T05_FECHA_BAJA=?, T05_PLANTILLA_VALID=? WHERE T05_ID_PLANTILLA_VALID=?";

		this.jdbcTemplate.update(query, ab18a05s00.getT06IdBoletin(),
				ab18a05s00.getT05FechaBaja(),
				ab18a05s00.getT05PlantillaValid(),
				ab18a05s00.getT05IdPlantillaValid());
		return ab18a05s00;
	}

	/**
	 * Finds a single row in the Ab18a05s00 table.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @return Ab18a05s00
	 */
	@Transactional(readOnly = true)
	public Ab18aPlantillasXSLT find(Ab18aPlantillasXSLT ab18a05s00) {
		String query = "SELECT t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID, t1.T05_FECHA_BAJA T05FECHABAJA, t1.T05_PLANTILLA_VALID T05PLANTILLAVALID, t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN, t2.T06_DESC AB18A06S00T06DESC, t2.T06_LOGIN AB18A06S00T06LOGIN, t2.T06_PASS AB18A06S00T06PASS, t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF FROM AB18A05S00 t1 , AB18A06S00 t2  WHERE t1.T05_ID_PLANTILLA_VALID = ?   AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+)";

		List<Ab18aPlantillasXSLT> ab18a05s00List = this.jdbcTemplate.query(
				query, this.rwMap, ab18a05s00.getT05IdPlantillaValid());
		return (Ab18aPlantillasXSLT) DataAccessUtils
				.uniqueResult(ab18a05s00List);
	}

	/**
	 * Removes a single row in the Ab18a05s00 table.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @return
	 */
	public void remove(Ab18aPlantillasXSLT ab18a05s00) {
		String query = "DELETE FROM AB18A05S00 WHERE T05_ID_PLANTILLA_VALID=?";
		this.jdbcTemplate.update(query, ab18a05s00.getT05IdPlantillaValid());
	}

	/**
	 * Finds a list of rows in the Ab18a05s00 table.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a05s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aPlantillasXSLT> findAll(Ab18aPlantillasXSLT ab18a05s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID,t1.T05_FECHA_BAJA T05FECHABAJA,t1.T05_PLANTILLA_VALID T05PLANTILLAVALID,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		query.append("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a05s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aPlantillasXSLT>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a05s00 table using like.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a05s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aPlantillasXSLT> findAllLike(
			Ab18aPlantillasXSLT ab18a05s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID,t1.T05_FECHA_BAJA T05FECHABAJA,t1.T05_PLANTILLA_VALID T05PLANTILLAVALID,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		query.append("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a05s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aPlantillasXSLT>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a05s00 table.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aPlantillasXSLT ab18a05s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A05S00 t1 , AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a05s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab18a05s00 table using like.
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aPlantillasXSLT ab18a05s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A05S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a05s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a05s00 selected for rup_table
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a05s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aPlantillasXSLT>> reorderSelection(
			Ab18aPlantillasXSLT ab18a05s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID,t1.T05_FECHA_BAJA T05FECHABAJA,t1.T05_PLANTILLA_VALID T05PLANTILLAVALID,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a05s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Ab18aPlantillasXSLT.class,
				filterParamList, "T05_ID_PLANTILLA_VALID");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aPlantillasXSLT>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a05s00
	 * @param searchParams
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a05s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aPlantillasXSLT>> search(
			Ab18aPlantillasXSLT filterParams, Ab18aPlantillasXSLT searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID,t1.T05_FECHA_BAJA T05FECHABAJA,t1.T05_PLANTILLA_VALID T05PLANTILLAVALID,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Ab18aPlantillasXSLT.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"T05_ID_PLANTILLA_VALID");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aPlantillasXSLT>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aPlantillasXSLT filterab18a05s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID,t1.T05_FECHA_BAJA T05FECHABAJA,t1.T05_PLANTILLA_VALID T05PLANTILLAVALID,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a05s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						Ab18aPlantillasXSLT.class, query, params,
						"T05_ID_PLANTILLA_VALID");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a05s00 table.
	 * 
	 * @param filterAb18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a05s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aPlantillasXSLT>> findAllLikeJerarquia(
			Ab18aPlantillasXSLT filterAb18a05s00,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T05_ID_PLANTILLA_VALID T05IDPLANTILLAVALID,t1.T05_FECHA_BAJA T05FECHABAJA,t1.T05_PLANTILLA_VALID T05PLANTILLAVALID,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A05S00");
		from.add("AB18A06S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a05s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "T05_ID_PLANTILLA_VALID", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aPlantillasXSLT filterAb18a05s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A05S00");
		from.add("AB18A06S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a05s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "T05_ID_PLANTILLA_VALID",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a05s00
	 *            Ab18a05s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a05s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aPlantillasXSLT>> findAllChild(
			Ab18aPlantillasXSLT filterAb18a05s00,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A05S00 t1 ,AB18A06S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A05S00");
		from.add("AB18A06S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a05s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "T05_ID_PLANTILLA_VALID",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Ab18aPlantillasXSLT>(this.rwMapPK,
						"T05_ID_PLANTILLA_VALID"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a05s00 entity
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aPlantillasXSLT ab18a05s00) {

		StringBuilder where = new StringBuilder(
				Ab18aPlantillasXSLTDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a05s00 != null && ab18a05s00.getT05IdPlantillaValid() != null) {
			where.append(" AND t1.T05_ID_PLANTILLA_VALID = ?");
			params.add(ab18a05s00.getT05IdPlantillaValid());
		}

		if (ab18a05s00 != null && ab18a05s00.getT05FechaBaja() != null) {
			where.append(" AND t1.T05_FECHA_BAJA = ?");
			params.add(ab18a05s00.getT05FechaBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a05s00 entity
	 * 
	 * @param ab18a05s00
	 *            Ab18a05s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aPlantillasXSLT ab18a05s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ab18aPlantillasXSLTDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a05s00 != null && ab18a05s00.getT05IdPlantillaValid() != null) {
			where.append(" AND t1.T05_ID_PLANTILLA_VALID = ?");
			params.add(ab18a05s00.getT05IdPlantillaValid());
		}

		if (ab18a05s00 != null && ab18a05s00.getT05FechaBaja() != null) {
			where.append(" AND t1.T05_FECHA_BAJA = ?");
			params.add(ab18a05s00.getT05FechaBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
